package jamezo97.clonecraft;

import jamezo97.clonecraft.block.CentrifugeRenderHandler;
import jamezo97.clonecraft.block.TileEntityCentrifugeRenderer;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.dna.GeneTeleport;
import jamezo97.clonecraft.dna.IModifiable;
import jamezo97.clonecraft.network.Handler17TeleportPlayer;
import jamezo97.clonecraft.render.RenderClientPlayer;
import jamezo97.clonecraft.render.RenderClone;
import jamezo97.clonecraft.render.RenderCustom;
import jamezo97.clonecraft.render.RenderSpawnEgg;
import jamezo97.clonecraft.sounds.MySoundManager;

import java.util.EnumSet;
import java.util.Random;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.CCEntityClientPlayerMP;
import net.minecraft.client.entity.CCEntityOtherPlayerMP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.MinecraftForge;

import org.lwjgl.input.Keyboard;

import com.google.common.base.Function;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.KeyBindingRegistry.KeyHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.EntityRegistry.EntityRegistration;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ClientProxy extends CommonProxy implements ITickHandler{



	public ClientProxy() {
		super();
		mc = Minecraft.getMinecraft();
	}

	Minecraft mc;

	public void load(CloneCraft craft){
		super.load(craft);
		Logger.log("Loading client-specific aspects.");
		LanguageRegistry.instance().addStringLocalization("itemGroup.CloneCraft", "Clone Craft");


		int nextRenderID = RenderingRegistry.getNextAvailableRenderId();
		RenderingRegistry.registerBlockHandler(new CentrifugeRenderHandler(nextRenderID));
		CloneCraft.centrifuge.setRenderID(nextRenderID);


		TileEntityRenderer.instance.specialRendererMap.put(jamezo97.clonecraft.block.TileEntityCentrifuge.class, new TileEntityCentrifugeRenderer());

		MinecraftForge.EVENT_BUS.register(new MySoundManager());
		MinecraftForge.EVENT_BUS.register(new EventSubscribed());
		TickRegistry.registerTickHandler(this, Side.CLIENT);


		RenderingRegistry.registerEntityRenderingHandler(jamezo97.clonecraft.entity.EntitySpawnEgg.class, new RenderSpawnEgg());
		RenderingRegistry.registerEntityRenderingHandler(jamezo97.clonecraft.entity.clone.EntityClone.class, new RenderClone());
		RenderingRegistry.registerEntityRenderingHandler(net.minecraft.entity.CCEntityAnything.class, new RenderCustom());

		Render r;
		RenderingRegistry.registerEntityRenderingHandler(net.minecraft.client.entity.CCEntityClientPlayerMP.class, r = new RenderClientPlayer());
		RenderingRegistry.registerEntityRenderingHandler(net.minecraft.client.entity.CCEntityOtherPlayerMP.class, r);

		
		int CCEntityClientPlayerMP;
		EntityRegistry.registerGlobalEntityID(net.minecraft.client.entity.CCEntityClientPlayerMP.class, "CCEntityClientPlayerMP", CCEntityClientPlayerMP = EntityRegistry.findGlobalUniqueEntityId());
		EntityRegistry.registerModEntity(net.minecraft.client.entity.CCEntityClientPlayerMP.class, "CCEntityClientPlayerMP", CCEntityClientPlayerMP, craft, 512, 2, true);
		
		int CCEntityOtherPlayerMP;
		EntityRegistry.registerGlobalEntityID(net.minecraft.client.entity.CCEntityOtherPlayerMP.class, "CCEntityOtherPlayerMP", CCEntityOtherPlayerMP = EntityRegistry.findGlobalUniqueEntityId());
		EntityRegistry.registerModEntity(net.minecraft.client.entity.CCEntityOtherPlayerMP.class, "CCEntityOtherPlayerMP", CCEntityOtherPlayerMP, craft, 512, 2, true);

		
		EntityRegistration er = EntityRegistry.instance().lookupModSpawn(FMLCommonHandler.instance().findContainerFor(craft), CCEntityPlayerMPID);
		er.setCustomSpawning(new Function<EntitySpawnPacket, Entity>(){
			@Override
			public Entity apply(EntitySpawnPacket packet) {
				if(packet.entityId != Minecraft.getMinecraft().thePlayer.entityId){
					String username = packet.dataStream.readUTF();
					Logger.getAttention();
					Logger.log("Creating client with uname " + username);
					Entity entity = new CCEntityOtherPlayerMP(Minecraft.getMinecraft().theWorld, username);
	                int offset = packet.entityId - entity.entityId;
	                entity.entityId = packet.entityId;
	                entity.setLocationAndAngles(packet.scaledX, packet.scaledY, packet.scaledZ, packet.scaledYaw, packet.scaledPitch);
	                if (entity instanceof EntityLiving)
	                {
	                    ((EntityLiving)entity).rotationYawHead = packet.scaledHeadYaw;
	                }

	                Entity parts[] = entity.getParts();
	                if (parts != null)
	                {
	                    for (int j = 0; j < parts.length; j++)
	                    {
	                        parts[j].entityId += offset;
	                    }
	                }
					return entity;
				}
				return null;
			}
			
		}, false);
		
		
		final KeyBinding keyBindTeleport = new KeyBinding("Teleport", Keyboard.KEY_F);

		KeyBindingRegistry.registerKeyBinding(new KeyHandler(new KeyBinding[]{keyBindTeleport}, new boolean[]{true}){



			@Override
			public String getLabel() {
				return "Teleport Binding";
			}

			@Override
			public void keyDown(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd, boolean isRepeat) {
				if(kb == keyBindTeleport){
					isTeleportKeyDown = true;
				}
				
			}

			@Override
			public void keyUp(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd) {
				if(kb == keyBindTeleport){
					isTeleportKeyDown = false;
				}
			}

			@Override
			public EnumSet<TickType> ticks() {
				return EnumSet.of(TickType.CLIENT);
			}

		});

	}
	
	public static boolean isTeleportKeyDown;
	
	public static boolean isTeleportKeyDown(){
		return isTeleportKeyDown;
	}

	public void postInit(){
		super.postInit();

	}
	/*	
	int fxLayerID = 0;

	public void addCustomFXLayer(){	
		Minecraft mc = Minecraft.getMinecraft();
		List[] values = Reflect.get(mc.effectRenderer, Reflect.fxLayers, List[].class);
		if(values != null){
			List[] fxLayers = new List[values.length+1];
			System.arraycopy(values, 0, fxLayers, 0, values.length);
			fxLayers[fxLayers.length-1] = new ArrayList();
			fxLayerID = fxLayers.length-1;
		}
	}*/


	@Override
	public void tickStart(EnumSet<TickType> type, Object... tickData) {
		if(type.contains(TickType.CLIENT)){
			CloneCraft.instance.ticks++;
			updatePlayerTeleport();
		}else if(type.contains(TickType.RENDER)){
			if(mc.renderViewEntity != null && mc.renderViewEntity instanceof CCEntityClientPlayerMP){
				CCEntityClientPlayerMP player = (CCEntityClientPlayerMP)mc.renderViewEntity;
				float scale = player.getGeneScaling();
				player.yOffset = player.getBaseYOffset() - ((scale-1)*player.getBaseYOffset());//player.getBaseYOffset() / scale;
			}
		}
	}

	int teleportCountdown = 0;
	
	int teleportCountTo = 8;
	
	MovingObjectPosition targetMop = null;
	
	@SideOnly(value = Side.CLIENT)
	private void updatePlayerTeleport() {
		EntityPlayer player = Minecraft.getMinecraft().thePlayer;
		if(player != null && player instanceof IModifiable && ((IModifiable)player).hasGene(Gene.teleport)){
			if(isTeleportKeyDown()){
				MovingObjectPosition mop = player.rayTrace(GeneTeleport.getMaxTPDistance(), 1.0f);
				if(mop != null && mop.typeOfHit == EnumMovingObjectType.TILE){
					if(targetMop == null){
						targetMop = mop;
						teleportCountdown = 1;
					}else if(targetMop.blockX == mop.blockX && targetMop.blockY == mop.blockY && targetMop.blockZ == mop.blockZ){
						teleportCountdown++;
						if(teleportCountdown >= teleportCountTo){
							new Handler17TeleportPlayer(player, mop.blockX, mop.blockY, mop.blockZ).sendToServer();
							teleportCountdown = 0;
						}
					}else{
						targetMop = mop;
						teleportCountdown = 0;
						return;
					}
					
				}
			}else{
				targetMop = null;
				teleportCountdown = 0;
			}
		}
	}

	Random rand = new Random();
	
	@Override
	public void tickEnd(EnumSet<TickType> type, Object... tickData) {
		if(type.contains(TickType.RENDER)){
			if(mc.renderViewEntity != null && mc.renderViewEntity instanceof CCEntityClientPlayerMP){
				CCEntityClientPlayerMP player = (CCEntityClientPlayerMP)mc.renderViewEntity;
				float scale = player.getGeneScaling();
				
				player.yOffset = player.getBaseYOffset() * scale;// - ((scale-1)*player.getBaseYOffset());
//				System.out.println(player.yOffset);
			}
			
		}
	}

	@Override
	public EnumSet<TickType> ticks() {
		return EnumSet.of(TickType.CLIENT, TickType.RENDER);
	}

	@Override
	public String getLabel() {
		return "CloneCraftTick";
	}

	/*	public int getFXLayerID() {
		return fxLayerID;
	}*/




}
